/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.CallHomeData;
import com.ibm.hsc.auiml.databeans.sfp.data.StructuredData;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventList;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionState;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionStateList;
import com.ibm.hsc.sfp.surveillance.SurveillanceTerminateThread;
import com.ibm.hsc.websm.sfp.SelectServiceableEvent;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.hwmca.server.bridge.NativeBridge;
import com.ibm.hwmca.server.bridge.NativeBridgeListener;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;

public class Surveillance
implements NativeBridgeListener {
    public static final String CEC_MTM_MS_SEPARATOR = "_";
    static final ClassLogInfo SURVEILLANCE_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurveilla");
    static final ClassLogInfo SURVEILLANCE_TIMER_THREAD_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurvTimeT");
    static final ClassLogInfo SURVEILLANCE_EVENT_LIST_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurvEvtLS");
    static final ClassLogInfo SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurvPartL");
    static final short ERRID_PROCESS_SE_ERR = 0;
    static final short ERRID_GETTING_ENABLEMENT_FROM_CIM = 1;
    static final short ERRID_GETTING_CEC_MODE_FROM_CIM = 2;
    static final short ERRID_CALLING_SA = 3;
    static final short ERRID_GET_HMC_MTM = 4;
    static final short ERRID_GET_HMC_MS = 5;
    static final short ERRID_SUBSCRIBING_TO_CIM = 6;
    static final short ERRID_UNSUBSCRIBING_FROM_CIM = 7;
    static final short ERRID_TIMER_THREAD_ERR = 8;
    static final boolean USE_FAKE_CIM_DATA = false;
    static final long REQUIRE_CONNECT_TIMER_IN_MS = 1800000L;
    private static final String TRACE_MASKD = "JSURVEID";
    private static final String TRACE_MASKF = "JSURVEIF";
    private static final String TRACE_MASKT = "JSURVEIT";
    private static Surveillance surveillanceObject = null;
    private static Object surveillanceObjectSynchronizer = new Object();
    private SurveillanceEventList eventList = null;
    private SurveillancePartitionStateList partitionStates = null;
    private long connectTimer = 0L;
    private long outageTimer = 0L;
    private long newSETimer = 0L;
    private Vector cecsDisabled = null;
    private boolean localConnectionUp = false;
    private NativeBridge bridge = null;
    private Object surveillanceObjectTerminator = new Object();
    private boolean terminated = false;

    public Surveillance() {
        this(null);
    }

    public Surveillance(NativeBridge nativeBridge) {
        if (nativeBridge != null) {
            nativeBridge.addNativeBridgeListener((NativeBridgeListener)this);
            this.bridge = nativeBridge;
        }
    }

    public static void main(String[] stringArray) {
        Surveillance surveillance = new Surveillance();
        try {
            Surveillance.callSALocalDisconnected("001", "7923-1U", "23WW193");
            Surveillance.callSALocalDisconnected("002", "6792-31U", "23WW193");
            Surveillance.callSALocalDisconnected("003", "792-31U", "23WW193");
        }
        catch (SFPException sFPException) {
            sFPException.printStackTrace();
        }
    }

    public void init(int n, int n2, int n3) {
        Trace.trace(TRACE_MASKT, "-> init(" + n + ", " + n2 + ", " + n3 + ")");
        this.initMS(n * 60000, n2 * 60000, n3 * 60000);
        Trace.trace(TRACE_MASKT, "<- init(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMS(long l, long l2, long l3) {
        Trace.trace(TRACE_MASKT, "-> initMS(" + l + ", " + l2 + ", " + l3 + ")");
        Object object = surveillanceObjectSynchronizer;
        synchronized (object) {
            if (surveillanceObject != null) {
                surveillanceObject.terminate();
            }
            this.partitionStates = new SurveillancePartitionStateList(this);
            this.eventList = new SurveillanceEventList(this, this.partitionStates);
            this.partitionStates.subscribeForCIMEvents(this.eventList);
            this.partitionStates.updateCIMInfo(this.eventList);
            this.cecsDisabled = new Vector();
            this.connectTimer = l;
            this.outageTimer = l2;
            this.newSETimer = l3;
            surveillanceObject = this;
        }
        Trace.trace(TRACE_MASKT, "<- initMS(...)");
    }

    public void connected(String string, String string2, String string3, String string4) {
        Trace.trace(TRACE_MASKT, "-> connected(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        this.addConnect(string, string2, string3, string4);
        Trace.trace(TRACE_MASKT, "<- connected(...)");
    }

    public void disconnected(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Trace.trace(TRACE_MASKT, "-> disconnected(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6 + ", " + string7 + ")");
        if (string6 != null && string6.indexOf(45) == -1 && string6.length() > 4) {
            string6 = string6.substring(0, 4) + "-" + string6.substring(4);
        }
        this.addDisconnect(string, string2, string3, string4, string5, string6, string7);
        Trace.trace(TRACE_MASKT, "<- disconnected(...)");
    }

    public synchronized void localConnected() {
        Trace.trace(TRACE_MASKT, "-> localConnected()");
        this.localConnectionUp = true;
        Trace.trace(TRACE_MASKT, "<- localConnected()");
    }

    public synchronized void localDisconnected(String string, String string2, String string3) {
        Trace.trace(TRACE_MASKT, "-> localDisconnected(" + string + ", " + string2 + ", " + string3 + ")");
        if (this.localConnectionUp) {
            if (string2 != null && string2.indexOf(45) == -1 && string2.length() > 4) {
                string2 = string2.substring(0, 4) + "-" + string2.substring(4);
            }
            try {
                Surveillance.callSALocalDisconnected(string, string2, string3);
            }
            catch (SFPException sFPException) {
                new AusMicrocodeLog(SURVEILLANCE_LOG_INFO, 3, sFPException).writeEntry(null);
            }
            this.localConnectionUp = false;
        } else {
            Trace.trace(TRACE_MASKD, "Ignoring duplicate localDisconnected(...) call");
        }
        Trace.trace(TRACE_MASKT, "<- localDisconnected(...)");
    }

    public void setTimers(int n, int n2, int n3) {
        Trace.trace(TRACE_MASKT, "-> setTimers(" + n + ", " + n2 + ", " + n3 + ")");
        this.setConnectTimer(n);
        this.setOutageTimer(n2);
        this.setNewSETimer(n3);
        Trace.trace(TRACE_MASKT, "<- setTimers(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurveillance(String string, String string2, boolean bl) {
        String string3 = null;
        Trace.trace(TRACE_MASKT, "-> setSurveillance(" + string + ", " + string2 + ", " + bl + ")");
        string3 = string + CEC_MTM_MS_SEPARATOR + string2;
        Vector vector = this.cecsDisabled;
        synchronized (vector) {
            if (bl) {
                this.cecsDisabled.remove(string3);
            } else if (!this.cecsDisabled.contains(string3)) {
                this.cecsDisabled.add(string3);
            }
        }
        Trace.trace(TRACE_MASKT, "<- setSurveillance(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Trace.trace(TRACE_MASKT, "-> terminate()");
        Object object = this.surveillanceObjectTerminator;
        synchronized (object) {
            if (!this.terminated) {
                new Thread((Runnable)new SurveillanceTerminateThread(this, this.bridge), "SurveillanceTerminateThread").start();
                this.terminated = true;
                this.bridge = null;
            }
        }
        Trace.trace(TRACE_MASKT, "<- terminate(...)");
    }

    private void setConnectTimer(int n) {
        if (this.connectTimer != (long)(n * 60000)) {
            this.connectTimer = n * 60000;
            this.eventList.change(SurveillanceEventType.CONNECT, this.connectTimer);
            this.eventList.change(SurveillanceEventType.NOT_YET_CONNECTED, 1800000L + (long)n);
        }
    }

    long getConnectTimerInMS() {
        return this.connectTimer;
    }

    private void setOutageTimer(int n) {
        if (this.outageTimer != (long)(n * 60000)) {
            this.outageTimer = n * 60000;
            this.eventList.change(SurveillanceEventType.DISCONNECT, this.outageTimer);
        }
    }

    private void setNewSETimer(int n) {
        this.newSETimer = n * 60000;
    }

    private void addConnect(String string, String string2, String string3, String string4) {
        Date date = null;
        String string5 = null;
        SurveillancePartitionState surveillancePartitionState = null;
        date = new Date();
        try {
            surveillancePartitionState = this.partitionStates.get(string3, string4, string);
            if (surveillancePartitionState != null) {
                string5 = surveillancePartitionState.getUserName();
            }
        }
        catch (CIMException cIMException) {
            Trace.trace(TRACE_MASKF, "In addConnect(...), we got the following exception while getting the user name: " + cIMException.toString());
        }
        if (string5 == null) {
            string5 = "";
        }
        this.eventList.add(new SurveillanceEvent(string, string5, string2, date, SurveillanceEventType.CONNECT, string3, string4, null, "", ""), this.connectTimer);
    }

    private void addDisconnect(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Date date = null;
        String string8 = null;
        SurveillancePartitionState surveillancePartitionState = null;
        date = new Date();
        try {
            surveillancePartitionState = this.partitionStates.get(string3, string4, string);
            if (surveillancePartitionState != null) {
                string8 = surveillancePartitionState.getUserName();
            }
        }
        catch (CIMException cIMException) {
            Trace.trace(TRACE_MASKF, "In addDisconnect(...), we got the following exception while getting the user name: " + cIMException.toString());
        }
        if (string8 == null) {
            string8 = "";
        }
        this.eventList.add(new SurveillanceEvent(string, string8, string2, date, SurveillanceEventType.DISCONNECT, string3, string4, string5, string6, string7), this.outageTimer);
    }

    boolean doSurveillancePerConfig(String string, String string2, String string3) {
        boolean bl = false;
        Trace.trace(TRACE_MASKT, "-> doSurveillance(" + string + ", " + string2 + ", " + string3 + ")");
        if (this.doSurveillanceForCEC(string2, string3)) {
            bl = this.doSurveillancePerProfile(string, string2, string3);
        }
        Trace.trace(TRACE_MASKT, "<- doSurveillance(...) returning " + bl);
        return bl;
    }

    private boolean doSurveillancePerProfile(String string, String string2, String string3) {
        SurveillancePartitionState surveillancePartitionState = null;
        boolean bl = false;
        Trace.trace(TRACE_MASKT, "-> doSurveillancePerCIM(" + string + ", " + string2 + ", " + string3 + ")");
        try {
            surveillancePartitionState = this.partitionStates.get(string2, string3, string);
            if (surveillancePartitionState != null) {
                bl = surveillancePartitionState.isInPartitionMode() ? surveillancePartitionState.isSurveillanceEnabled() : true;
            } else {
                Trace.trace(TRACE_MASKF, "In doSurveillancePerCIM(...), the partition cannot be found.");
            }
        }
        catch (CIMException cIMException) {
            Trace.trace(TRACE_MASKF, "In doSurveillancePerCIM(...), we do not have enough CIM information for the partition.");
        }
        Trace.trace(TRACE_MASKT, "<- doSurveillancePerCIM(...) returning " + bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSurveillanceForCEC(String string, String string2) {
        String string3 = null;
        boolean bl = true;
        Trace.trace(TRACE_MASKT, "-> doSurveillanceForCEC(" + string + ", " + string2 + ")");
        string3 = string + CEC_MTM_MS_SEPARATOR + string2;
        Vector vector = this.cecsDisabled;
        synchronized (vector) {
            if (this.cecsDisabled.contains(string3)) {
                bl = false;
            }
        }
        Trace.trace(TRACE_MASKT, "<- doSurveillanceForCEC(...) returning " + bl);
        return bl;
    }

    long getNewSETimer() {
        return this.newSETimer;
    }

    private static void callSALocalDisconnected(String string, String string2, String string3) throws SFPException {
        CallHomeData callHomeData = null;
        Object var4_4 = null;
        Trace.trace(TRACE_MASKT, "->callSALocalDisconnected(" + string + ", " + string2 + ", " + string3 + ")");
        callHomeData = new CallHomeData();
        callHomeData.setProperty("FDMachineType", string2);
        callHomeData.setProperty("FDMachineSerial", string3);
        callHomeData.setProperty("HSCID", string2);
        callHomeData.setProperty("HSCName", string3);
        callHomeData.setProperty("EverCallHome", "NO");
        callHomeData.setProperty("CalledHome", "NO");
        callHomeData.setProperty("Description", "Communication lost with the ctrmc RMC subsystem.");
        callHomeData.setProperty("Detail-Description", "Communication lost with the ctrmc RMC subsystem on the HMC with a serial number of " + string3 + ". Without this communication, serviceable events cannot be created on the HMC. The communication error code was " + string + ".");
        callHomeData.setProperty("OriginalTimeStamp", Surveillance.getTimeStamp());
        callHomeData.setProperty("ErrorClass", "SURVALNC");
        callHomeData.setProperty("ErrorCode", string);
        SelectServiceableEvent.callHome(callHomeData);
        Trace.trace(TRACE_MASKT, "<-callSALocalDisconnected(...)");
    }

    static String getTranslatedErrorText(String string, String string2, String string3, String string4) {
        Object[] objectArray = null;
        objectArray = new Object[]{string3};
        return HSCResourceBundleUtil.getMessage(new Locale(string, string2), "SFPResourceBundleMessages", "0109", "Communications to the SFP component on partition " + string3 + " are unavailable.", objectArray, false);
    }

    static String getTimeStamp() {
        Date date = new Date();
        return StructuredData.TS_FORMATTER.format(date);
    }

    public void connectionEstablished(NativeBridge nativeBridge) {
    }

    public void connectionClosed(NativeBridge nativeBridge, IOException iOException) {
        Trace.trace(TRACE_MASKT, "->connectionClosed(" + nativeBridge + ", " + iOException);
        this.terminate();
        Trace.trace(TRACE_MASKT, "<-connectionClosed(...)");
    }

    void cleanup(NativeBridge nativeBridge) {
        Trace.trace(TRACE_MASKT, "->cleanup(" + nativeBridge + ")");
        this.eventList.deleteAll();
        this.partitionStates.unsubscribeForCIMEvents();
        if (nativeBridge != null) {
            Trace.trace(TRACE_MASKD, "removing ourselves as listener for bridge " + nativeBridge);
            nativeBridge.removeNativeBridgeListener((NativeBridgeListener)this);
            Trace.trace(TRACE_MASKD, "removed ourselves as listener.");
        }
        Trace.trace(TRACE_MASKT, "<-cleanup(...)");
    }
}

